using System;
using System.Collections.Generic;
using System.Text;

namespace Array1D
{
   class Program
   {
      static void Main(string[] args)
      {
         string[] daysOfWeek =
            { "Poniedziaek", "Wtorek", "roda", "Czwartek", "Pitek", "Sobota", "Niedziela" };
         string[] productNames = {
            "Niebieskie Piro",
            "Czerwone Piro",
            "Niebieska Gumka",
            "Czerwona Gumka"};

         Console.WriteLine("Dni tygodnia: ");
         for (int x = 0; x < daysOfWeek.Length - 1; x++)
         {
            Console.Write(string.Format("{0}\t", daysOfWeek[x]));
         }
         Console.WriteLine("\n");

         string[] blueProducts = Array.FindAll(productNames, IsBlueProduct);
         Console.WriteLine("Wszystkie niebieskie produkty:");
         foreach (string product in blueProducts)
         {
            Console.Write(string.Format("{0}\t", product));
         }
         Console.WriteLine();
         Array.ForEach(productNames, UpperCaseString);

         Console.ReadLine();
      }

      static bool IsBlueProduct(string productName)
      {
         if (productName.ToUpper().Contains("NIEBIESKIE") ||
            productName.ToUpper().Contains("NIEBIESKA") ||
            productName.ToUpper().Contains("NIEBIESKI"))
            return true;
         else
            return false;
      }

      static void UpperCaseString(string productName)
      {
         Console.WriteLine(productName.ToUpper());
      }
   }
}
